  // NCIT      Description, Relationships, Metadata
  // SNOMED-CT Relationships
  // MDDVS     Relationships, Metadata
  // CDISC     Description
  // DOID      Description, Relationships, ?Metadata? Note: It is variable if a concept in DOID has a definition.
  // HP        Description, Relationships, Metadata
  // ICD9      Relationships, Metadata
  // ICD10     Relationships, Metadata
  // <util:map id="ontologyNamesMap">
  //   <entry key="HTTP://NCICB.NCI.NIH.GOV/XML/OWL/EVS/THESAURUS.OWL" value="NCIT" />
  //   <entry key="HTTP://SNOMED.INFO/ID" value="SNOMED" />
  //   <entry key="HTTP://RDF.CDISC.ORG/" value="CDISC" />
  //   <entry key="HTTP://WWW.SEMANTICWEB.ORG/ONTOLOGIES/2012/8/ONTOLOGY1347204983370.OWL" value="Survey" />
  //   <entry key="HTTP://PURL.OBOLIBRARY.ORG/OBO/DOID" value="DOID" />
  //   <entry key="HTTP://PURL.OBOLIBRARY.ORG/OBO/HP_" value="HP" />
  //   <entry key="HTTP://PURL.BIOONTOLOGY.ORG/ONTOLOGY/HOM-ICD9CM/" value="ICD9" />
  //   <entry key="HTTP://PURL.BIOONTOLOGY.ORG/ONTOLOGY/ICD10CM/" value="ICD10" />
  //   <entry key="HTTP://GENISIS.VA.GOV/MVP-SCHEMA#" value="MVP" />
  // </util:map>

function getDefaultTemplate() {
  return [
    {
      "order": "1",
      "tabname": "Description",
      "tablink": "description",
      "default": false,
      "properties": [
        {
          "propertyDisplay": "Definitions",
          "propertyName": "definitions",
          "componentType": "lists",
          "isUriLinked": false,
        },
        {
          "propertyDisplay": "Alt-definitions",
          "propertyName": "alt-definitions",
          "componentType": "lists",
          "isUriLinked": false,
        },
        {
          "propertyDisplay": "Synonyms",
          "propertyName": "synonyms",
          "componentType": "lists",
          "isUriLinked": false,
        }
      ] 
    },
    {
      "order": "2",
      "tabname": "Relationships",
      "tablink": "relationships",
      "default": false,
      "groupLabel": null,
      "properties": [
        {
          "propertyDisplay": "Super Classes",
          "propertyName": "superClasses",
          "componentType": "lists",
          "isUriLinked": true,
        },
        {
          "propertyDisplay": "Sub Classes",
          "propertyName": "subClasses",
          "componentType": "lists",
          "isUriLinked": true,
        },
      ] 
    },
    {
      "order": "3",
      "tabname": "Metadata",
      "tablink": "metadata",
      "default": false,
      "properties": [
        {
          "propertyDisplay": "Inter-Ontology Links",
          "propertyName": "interOntologyLinks",
          "componentType": "lists",
          "isUriLinked": true
        },
        {
          "propertyDisplay": "Properties",
          "propertyName": "properties",
          "componentType": "columns",
          "columns": [
            {
              "order": 1,
              "columnDisplayName": "Property Name",
              "columnName": "propertyName",
              "isUriLinked": false,
              "uriLink": null,
              "columnSize": 4
            }, {
              "order": 2,
              "columnDisplayName": "Property Value",
              "columnName": "propertyValue",
              "isUriLinked": false,
              "uriLink": null,
              "columnSize": 8
            }
          ]
        },
        {
          "propertyDisplay": "Meta Relationship",
          "propertyName": "metaRelationships",
          "componentType": "columns",
          "columns": [
            {
              "order": 1,
              "columnDisplayName": "Relationship Name",
              "columnName": "relationshipName",
              "isUriLinked": true,
              "uriLink": "relationshipUri",
              "columnSize": 4,
            },
            {
              "order": 2,
              "columnDisplayName": "Relationship Value",
              "columnName": "relatedConcept",
              "isUriLinked": true,
              "uriLink": "relatedConceptUri",
              "columnSize": 8,
            }
          ]
        },
        {
          "isGrouping": true,
          "groupDisplayName": "Mapping Information",
          "properties": [
            {
              "propertyDisplay": "Data Elements",
              "propertyName": "dataElements",
              "propertyGrouping": "1",
              "componentType": "lists",
              "isUriLinked": true
            },
            {
              "propertyDisplay": "Alogrithm",
              "propertyName": "algorithm",
              "propertyGrouping": "1",
              "componentType": "text",
              "isUriLinked": false
            },
            {
              "propertyDisplay": "Validation",
              "propertyName": "validation",
              "propertyGrouping": "1",
              "componentType": "text",
              "isUriLinked": false
            }
          ]
        }
      ] 
    },
  ];
}

// temporary mappings
export const TEMPLATE_MAPPINGS = {
  "DEFAULT": getDefaultTemplate(),
  "CDISC": [
    {
      "order": "1",
      "tabname": "Description",
      "tablink": "description",
      "default": false,
      "properties": [
        {
          "propertyDisplay": "Label",
          "propertyName": "name",
          "componentType": "text",
          "isUriLinked": false,
        },
        {
          "propertyDisplay": "Definitions",
          "propertyName": "definitions",
          "componentType": "lists",
          "isUriLinked": false,
        }
      ] 
    },
    {
      "order": "2",
      "tabname": "Relationships",
      "tablink": "relationships",
      "default": false,
      "properties": [
        {
          "propertyDisplay": "Super Classes",
          "propertyName": "superClasses",
          "componentType": "lists",
          "isUriLinked": true,
        },
        {
          "propertyDisplay": "Sub Classes",
          "propertyName": "subClasses",
          "componentType": "lists",
          "isUriLinked": true,
        }
      ] 
    }
  ],
  "SNOMED": [
    {
      "order": "1",
      "tabname": "Description",
      "tablink": "description",
      "default": false,
      "properties": [
        {
          "propertyDisplay": "Label",
          "propertyName": "name",
          "componentType": "text",
          "isUriLinked": false,
        },
        {
          "propertyDisplay": "Synonyms",
          "propertyName": "synonyms",
          "componentType": "lists",
          "isUriLinked": false,
        }
      ] 
    },
    {
      "order": "2",
      "tabname": "Relationships",
      "tablink": "relationships",
      "default": false,
      "properties": [
        {
          "propertyDisplay": "Super Classes",
          "propertyName": "superClasses",
          "componentType": "lists",
          "isUriLinked": true,
        },
        {
          "propertyDisplay": "Sub Classes",
          "propertyName": "subClasses",
          "componentType": "lists",
          "isUriLinked": true,
        }
      ] 
    }
  ],
  "NCIT": [
    {
      "order": "1",
      "tabname": "Description",
      "tablink": "description",
      "default": false,
      "properties": [
        {
          "propertyDisplay": "Label",
          "propertyName": "name",
          "componentType": "text",
          "isUriLinked": false,
        },
        {
          "propertyDisplay": "Definitions",
          "propertyName": "definitions",
          "componentType": "lists",
          "isUriLinked": false,
        },
        {
          "propertyDisplay": "Synonyms",
          "propertyName": "synonyms",
          "componentType": "lists",
          "isUriLinked": false,
        }
      ] 
    },
    {
      "order": "2",
      "tabname": "Relationships",
      "tablink": "relationships",
      "default": false,
      "properties": [
        {
          "propertyDisplay": "Super Classes",
          "propertyName": "superClasses",
          "componentType": "lists",
          "isUriLinked": true,
        },
        {
          "propertyDisplay": "Sub Classes",
          "propertyName": "subClasses",
          "componentType": "lists",
          "isUriLinked": true,
        }
      ] 
    }
  ],
  "DOID": [
    {
      "order": "1",
      "tabname": "Description",
      "tablink": "description",
      "default": false,
      "groupLabel": null,
      "properties": [
        {
          "propertyDisplay": "Label",
          "propertyName": "name",
          "componentType": "text",
          "isUriLinked": false,  
        },
        {
          "propertyDisplay": "Definitions",
          "propertyName": "definitions",
          "componentType": "lists",
          "isUriLinked": false,
        },
      ] 
    },
    {
      "order": "2",
      "tabname": "Relationships",
      "tablink": "relationships",
      "default": false,
      "groupLabel": null,
      "properties": [
        {
          "propertyDisplay": "Super Classes",
          "propertyName": "superClasses",
          "componentType": "lists",
          "isUriLinked": true,
        },
        {
          "propertyDisplay": "Sub Classes",
          "propertyName": "subClasses",
          "componentType": "lists",
          "isUriLinked": true,
        },
      ] 
    },
  ],
  "HP": [
    {
      "order": "1",
      "tabname": "Description",
      "tablink": "description",
      "default": false,
      "groupLabel": null,
      "properties": [
        {
          "propertyDisplay": "Label",
          "propertyName": "name",
          "componentType": "text",
          "isUriLinked": false,
        },
        {
          "propertyDisplay": "Definitions",
          "propertyName": "definitions",
          "componentType": "lists",
          "isUriLinked": false,
        },
        {
          "propertyDisplay": "Synonyms",
          "propertyName": "synonyms",
          "componentType": "lists",
          "isUriLinked": false,
        },
        {
          "propertyDisplay": "Associated Genes",
          "propertyName": "genesAssociatedWithDiseases",
          "componentType": "lists",
          // "columns": [
          //   {
          //     "order": 1,
          //     "columnDisplayName": "Associated Genes",
          //     "columnName": "propertyValue",
          //     "isUriLinked": false,
          //     "uriLink": null,
          //     "columnSize": 12
          //   }
          // ],
          "isUriLinked": false,
        },     
      ] 
    },
    {
      "order": "2",
      "tabname": "Relationships",
      "tablink": "relationships",
      "default": false,
      "groupLabel": null,
      "properties": [
        {
          "propertyDisplay": "Super Classes",
          "propertyName": "superClasses",
          "componentType": "lists",
          "isUriLinked": true,
        },
        {
          "propertyDisplay": "Sub Classes",
          "propertyName": "subClasses",
          "componentType": "lists",
          "isUriLinked": true,
        },
      ] 
    },
  ],
  "MDDVS": [
    {
      "order": "1",
      "tabname": "Description",
      "tablink": "description",
      "default": false,
      "groupLabel": null,
      "properties": [
        {
          "propertyDisplay": "Label",
          "propertyName": "name",
          "componentType": "text",
          "isUriLinked": false,
        },
        {
          "propertyDisplay": "Comment",
          "propertyName": "comment",
          "componentType": "text",
          "isUriLinked": false,
        },
      ]
    },
    {
      "order": "2",
      "tabname": "Relationships",
      "tablink": "relationships",
      "default": false,
      "groupLabel": null,
      "properties": [
        {
          "propertyDisplay": "Super Classes",
          "propertyName": "superClasses",
          "componentType": "lists",
          "isUriLinked": true,
        },
        {
          "propertyDisplay": "Sub Classes",
          "propertyName": "subClasses",
          "componentType": "lists",
          "isUriLinked": true,
        },
      ] 
    },
  ],
  "Baseline Survey": [ // Mike check here if this is correct
    {
      "order": "1",
      "tabname": "Metadata",
      "tablink": "metadata",
      "default": false,
      "properties": [
        {
          "propertyDisplay": "Question Text",
          "propertyName": "questionText",
          "componentType": "text",
          "isUriLinked": false,
        },
        {
          "propertyDisplay": "Question Number",
          "propertyName": "questionNumber",
          "componentType": "text",
          "isUriLinked": false,
        },
        {
          "propertyDisplay": "Name",
          "propertyName": "name",
          "componentType": "text",
          "isUriLinked": false,
        },
        {
          "propertyDisplay": "Source",
          "propertyName": "source",
          "componentType": "text",
          "isUriLinked": false,
        },
        {
          "propertyDisplay": "Data Outcome",
          "propertyName": "dataOutcome",
          "componentType": "text",
          "isUriLinked": false,
        },
        {
          "propertyDisplay": "Data Wrangling/Transformation",
          "propertyName": "dataTransformation",
          "componentType": "text",
          "isUriLinked": false,
        },
        {
          "propertyDisplay": "Cleaned",
          "propertyName": "cleaned",
          "componentType": "text",
          "isUriLinked": false,
        },
        {
          "propertyDisplay": "Cleaning Procedure",
          "propertyName": "cleaningProcedure",
          "componentType": "text",
          "isUriLinked": false,
        },
        {
          "propertyDisplay": "Data Type",
          "propertyName": "type",
          "componentType": "text",
          "isUriLinked": true,
        },
        {
          "propertyDisplay": "Data Source",
          "propertyName": "dataSource",
          "componentType": "text",
          "isUriLinked": false,
        },
        {
          "propertyDisplay": "Element Type",
          "propertyName": "elementType",
          "componentType": "text",
          "isUriLinked": false,
        },
        {
          "propertyDisplay": "Sensitivity",
          "propertyName": "sensitivity",
          "componentType": "text",
          "isUriLinked": false,
        },
        {
          "propertyDisplay": "Specificity",
          "propertyName": "specificity",
          "componentType": "text",
          "isUriLinked": false,
        },
        {
          "propertyDisplay": "Units",
          "propertyName": "units",
          "componentType": "text",
          "isUriLinked": false,
        },
        {
          "propertyDisplay": "Validated By",
          "propertyName": "validatedBy",
          "componentType": "text",
          "isUriLinked": false,
        },
        {
          "propertyDisplay": "Universal Identifier (GUID)",
          "propertyName": "guid",
          "componentType": "text",
          "isUriLinked": false,
        },
      ]
    }
  ],
  "ICD9": [
    {
      "order": "1",
      "tabname": "Description",
      "tablink": "description",
      "default": false,
      "properties": [
        {
          "propertyDisplay": "Label",
          "propertyName": "name",
          "componentType": "text",
          "isUriLinked": false,
        },
        {
          "propertyDisplay": "ICD9 Code",
          "propertyName": "cbaseCode",
          "componentType": "text",
          "isUriLinked": false,         
        }
      ] 
    },
    {
      "order": "2",
      "tabname": "Relationships",
      "tablink": "relationships",
      "default": false,
      "properties": [
        {
          "propertyDisplay": "Super Classes",
          "propertyName": "superClasses",
          "componentType": "lists",
          "isUriLinked": true,
        },
        {
          "propertyDisplay": "Sub Classes",
          "propertyName": "subClasses",
          "componentType": "lists",
          "isUriLinked": true,
        },
      ] 
    },
  ],
  "ICD10": [
    {
      "order": "1",
      "tabname": "Description",
      "tablink": "description",
      "default": false,
      "groupLabel": null,
      "properties": [
        {
          "propertyDisplay": "Label",
          "propertyName": "name",
          "componentType": "text",
          "isUriLinked": false,
        },
        {
          "propertyDisplay": "ICD10 Code",
          "propertyName": "notation",
          "componentType": "text",
          "isUriLinked": false,
        }
      ] 
    },
    {
      "order": "2",
      "tabname": "Relationships",
      "tablink": "relationships",
      "default": false,
      "groupLabel": null,
      "properties": [
        {
          "propertyDisplay": "Super Classes",
          "propertyName": "superClasses",
          "componentType": "lists",
          "isUriLinked": true,
        },
        {
          "propertyDisplay": "Sub Classes",
          "propertyName": "subClasses",
          "componentType": "lists",
          "isUriLinked": true,
        },
      ] 
    },
  ],
}
